﻿using C1.Win.Themes;
using C1.Win.Ribbon;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RibbonThemesTest
{
    public partial class Form1 : C1RibbonForm
    {
        public Form1()
        {
            InitializeComponent();

        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            C1Theme theme = C1ThemeController.GetThemeByName("Material", true);

            //used when there is no C1Ribbon control on the Form, and the form being used is C1RibbonForm
            //BackgroundProp themeItem = (BackgroundProp)theme.Children.GetItemByPath("C1Ribbon365\\Form\\Title\\InactiveBackground");

            //used when there is C1Ribbon control on the Form, and the form being used is C1RibbonForm
            //in this scenario, the QAT panel of the C1Ribbon control is merged with the TitleBar of the C1RibbonForm
            BackgroundProp themeItem = (BackgroundProp)theme.Children.GetItemByPath("C1Ribbon365\\Form\\Qat\\Inactive\\Background");

            themeItem.Ref = null;
            themeItem.Value = new ThemeSolidBackground(Color.Black);

            C1ThemeController.ApplyThemeToControlTree(this, theme);
        }

        private void buttonNewForm_Click(object sender, EventArgs e)
        {
            Form1 f = new Form1();

            f.Show();
        }
    }
}