import { Component } from '@angular/core';
import * as GC from "@grapecity/spread-sheets";
import * as ExcelIO from '@grapecity/spread-excelio';

@Component({
	selector: 'app-root',
	templateUrl: './app.component.html',
	styleUrls: ['./app.component.css']
})

export class AppComponent {
	spread: GC.Spread.Sheets.Workbook;
	loadedFile: File;
	hostStyle = {
		width: '1000px',
		height: '800px'
	};

	workbookInit(args: { spread: GC.Spread.Sheets.Workbook; }) {
		this.spread = args.spread;
		let sheet = this.spread.getActiveSheet();

		sheet.suspendPaint();
		sheet.setValue(2, 2, "Select a .xlsx file and load it on spread by click button 'load excel'");
		sheet.resumePaint();
	}

	loadExcel() {
		let excelIO = new ExcelIO.IO();

		if (!this.loadedFile) {
			console.log('Please select a file');
			return;
		}

		excelIO.open(this.loadedFile, (json: Object) => {
			this.spread.fromJSON(json);
		});
	}

	onFileSelect(args: any) {
		this.loadedFile = args.files[0];
	}
}


