import { AfterViewInit, Component, inject, ViewChild } from '@angular/core';
import {
  MatDialog,
  MAT_DIALOG_DATA,
  MatDialogTitle,
  MatDialogContent,
} from '@angular/material/dialog';
import { MatButtonModule } from '@angular/material/button';
import * as wjcCore from '@mescius/wijmo';
import * as wjcGrid from '@mescius/wijmo.grid';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';

@Component({
  selector: 'dialog-data-example',
  templateUrl: 'dialog-data-example.html',
  imports: [MatButtonModule],
})
export class DialogDataExample {
  dialog = inject(MatDialog);

  openDialog() {
    this.dialog.open(DialogDataExampleDialog, {
      autoFocus: false,
    });
  }
}

@Component({
  selector: 'dialog-data-example-dialog',
  templateUrl: 'dialog-data-example-dialog.html',
  imports: [MatDialogTitle, MatDialogContent, WjGridModule],
})
export class DialogDataExampleDialog implements AfterViewInit {
  data: any[];
  selectedItem: string;

  @ViewChild('flex', { static: true }) flex: wjcGrid.FlexGrid;

  constructor() {
    this.data = this._getData();
  }

  ngAfterViewInit(): void {
    setTimeout(() => {
      var theGrid = new wjcGrid.FlexGrid('#theGrid', {
        autoGenerateColumns: false,
        columns: [
          { binding: 'country', header: 'Country', width: '2*' },
          { binding: 'sales', header: 'Sales', width: '*', format: 'n2' },
          { binding: 'expenses', header: 'Expenses', width: '*', format: 'n2' }
        ],
        itemsSource: this.data
      });
    }, 2000);
  }

  flexInitialized(flexgrid: wjcGrid.FlexGrid) {
    console.log('grid init');
  }

  private _getData() {
    // create some random data
    let countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','),
      data = [];
    for (let i = 0; i < countries.length; i++) {
      data.push({
        id: i,
        country: countries[i],
        sales: Math.random() * 10000,
        expenses: Math.random() * 5000,
      });
    }

    return data;
  }
}
