using C1.C1Preview;
using System.Diagnostics;
using System.Drawing.Imaging;
using System.Security.Cryptography.X509Certificates;

namespace PrintDocToPdf
{
    public partial class Form1 : Form
    {
        C1PrintDocument _doc;

        public Form1()
        {
            InitializeComponent();
            
            //generating sample C1PrintDocument
            _doc = new C1PrintDocument();
            _doc.Body.Children.Add(new RenderText("Hello World"));
            _doc.Generate();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //saving signed PDF
            var success = SignPDF("PrintDocToPdf.pdf", null, new RectangleF(50, 150, 100, 50), Image.FromFile(@"Files\signature.png"));

            //opening PDF
            if (success)
                Process.Start(new ProcessStartInfo("PrintDocToPdf.pdf") { UseShellExecute = true });
        }

        public bool SignPDF(string fileNameWithPath, X509Certificate2? cetificate, RectangleF location, Image signatureLogo)
        {
            //Use C1.Win.Pdf.C1PdfDocument instead of C1.Pdf.C1PdfDocuments
            C1.Win.Pdf.C1PdfDocument c1PdfDocument1 = new();
            foreach (C1Page page in _doc.Pages)
            {
                Image img = page.AsMetafile();
                c1PdfDocument1.DrawImage(img, c1PdfDocument1.PageRectangle);

                C1.Pdf.PdfSignature signature = new()
                {
                    Reason = "Signature",
                    Certificate = cetificate,
                    Visibility = C1.Pdf.FieldVisibility.Visible,
                    Handler = C1.Pdf.SignatureHandler.PPKLite
                };
                signature.BorderWidth = C1.Pdf.FieldBorderWidth.Thin;
                signature.BorderColor = Color.Gray;
                signature.BackColor = Color.DarkGray;

                //convert Image to GcImage using MemoryStream
                using (var mm = new MemoryStream())
                {
                    signatureLogo.Save(mm, ImageFormat.Png);
                    signature.Image = GrapeCity.Documents.Drawing.Image.FromBytes(mm.ToArray());
                }
                c1PdfDocument1.AddField(signature, location);
            }
            c1PdfDocument1.Save(fileNameWithPath);

            return true;
        }
    }
}
