﻿using C1.Win.C1FlexGrid;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.Windows.Forms;

namespace FlexGrid48_GroupFilter
{
    public partial class Form1 : Form
    {
        C1FlexGrid _grid;
        public Form1()
        {
            InitializeComponent();

            var adapter = new OleDbDataAdapter(GetSelectCommandText(), GetConnectionString());
            var data = new DataTable();
            adapter.Fill(data);

            _grid = new C1FlexGrid()
            {
                Dock = DockStyle.Fill,
                ColumnContextMenuEnabled = true,
                AllowFiltering = true,
                AllowMerging = AllowMergingEnum.Nodes,
                DataSource = data
            };
            this.Controls.Add(_grid);

            _grid.Cols["Sale Amount"].Aggregate = AggregateEnum.Sum;

            CreateGridGrouping();

            //Handle the event
            _grid.AfterFilter += Grid_AfterFilter;

            _grid.GroupHeaderFormat = "{name}: {value}";
        }

        private void Grid_AfterFilter(object sender, EventArgs e)
        {
            //Update the grouping
            CreateGridGrouping();
        }

        private void CreateGridGrouping()
        {
            _grid.GroupDescriptions = new List<GroupDescription>()
            {
                new GroupDescription("LastName"),
                new GroupDescription("ShipCountry")
            };
        }

        static string GetConnectionString()
        {
            //if process is 32bit use JET.OLEDB otherwise use ACE.OLEDB
            return $"Provider={(Environment.Is64BitProcess ? "Microsoft.Ace.OLEDB.12.0" : "Microsoft.Jet.OLEDB.4.0")};" +
                $@"Data Source={Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments)}\ComponentOne Samples\Common\C1NWind.mdb;";
        }

        static string GetSelectCommandText()
        {
            return "SELECT top 50 Employees.LastName, Orders.ShipCountry, Categories.CategoryName, " +
                "Products.ProductName, Orders.OrderDate, [Quantity]*[Products].[UnitPrice] AS [Sale Amount] " +
                "FROM (Categories INNER JOIN Products ON Categories.CategoryID = Products.CategoryID) " +
                "INNER JOIN ((Employees INNER JOIN Orders ON Employees.EmployeeID = Orders.EmployeeID) " +
                "INNER JOIN [Order Details] ON Orders.OrderID = [Order Details].OrderID) " +
                "ON Products.ProductID = [Order Details].ProductID " +
                "ORDER BY Employees.LastName, Orders.ShipCountry, Categories.CategoryName;";
        }
    }
}
