﻿using C1.Win.Chart;
using System;
using System.Linq;
using System.Windows.Forms;

namespace FlexChart_StackingBars
{
    public partial class Form1 : Form
    {
        FlexChart _chart;
        public Form1()
        {
            InitializeComponent();

            var rnd = new Random();
            var axisY = new Axis()
            {
                Position = C1.Chart.Position.Left
            };
            this.Controls.Add(_chart = new FlexChart()
            {
                Dock = DockStyle.Fill,
                DataSource = Enumerable.Range(1, 10).Select(idx =>
                {
                    return new
                    {
                        X = idx,
                        S1 = (rnd.NextDouble() / 4) + .75,
                        S2 = (rnd.NextDouble() / 4) + .75,
                        S3 = rnd.Next(50, 100),
                    };
                }),
                ChartType = C1.Chart.ChartType.Column,
                //BindingX = "X",
                Series =
                {
                    new Series()
                    {
                        Binding = "S1",
                        AxisY = axisY,
                        BindingX = "X",
                    },
                    new Series()
                    {
                        Binding = "S2",
                        AxisY = axisY,
                        BindingX = "X",
                    },
                    new Series()
                    {
                        Binding = "S3",
                        AxisY = new Axis()
                        {
                            Position = C1.Chart.Position.Right,
                            Max = 160
                        },
                        BindingX = "X",
                    }
                }
            });
        }
    }
}
