﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace NestedFG
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            parentFG.ItemsSource = GetDataSource();
        }

        public ObservableCollection<Student> GetDataSource()
        {
            Random rnd = new Random();
            ObservableCollection<Student> myStudents = new ObservableCollection<Student>();
            ObservableCollection<Marks> myMarks = new ObservableCollection<Marks>();
            for (int i = 0; i < 250; i++)
            {
                Marks mark = new Marks()
                {
                    Id = i + 1,
                    English = rnd.NextDouble() * 100,
                    Maths = rnd.NextDouble() * 100,
                    Science = rnd.NextDouble() * 100,
                };
                myMarks.Add(mark);
            }
            myStudents.Add(new Student()
            {
                Id = 1,
                StMarks = myMarks,
                Birthday = new DateTime(1971, 7, 23),
                Name = "John"
            });
            myStudents.Add(new Student()
            {
                Id = 2,
                StMarks = myMarks,
                Birthday = new DateTime(1980, 7, 23),
                Name = "Ray"
            });
            myStudents.Add(new Student()
            {
                Id = 3,
                StMarks = myMarks,
                Birthday = new DateTime(1991, 7, 23),
                Name = "Fred"
            });
            return myStudents;
        }
    }
}
