﻿using C1.Maui.Core;
using C1.Maui.Grid;

namespace AddDeleteConfirmation
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            flexGrid.ItemsSource = Customer.GetCustomerList(10);
            flexGrid.CellFactory = new MyCellFactory();
        }
    }

    class MyCellFactory : GridCellFactory
    {
        protected override bool OnKeyDown(KeyEventArgs e)
        {
            //if delete key is pressed
            if (e.Key == C1KeyboardHelper.Delete)
            {
                //handle the delete operation manually
                HandleDeleteRow();

                //cancel default delete operation by returning true
                return true;
            }

            return base.OnKeyDown(e);
        }

        private async void HandleDeleteRow()
        {
            if (Grid.CursorRange is not null && Grid.Rows[Grid.CursorRange.Row] is not GridNewRow)
            {
                //show alert and get confirmation from user
                var confirmed = await Application.Current?.MainPage?.DisplayAlert("Confirm Delete", "Do you want to delete this row?", "Yes", "No");
                if (confirmed)
                {
                    //save the current row and column
                    var row = Grid.CursorRange.Row;
                    var col = Grid.CursorRange.Column;

                    //delete the row
                    Grid.Rows.RemoveAt(row);

                    //select the current row and column back to select the next row
                    Grid.Select(row, col);
                    Grid.SetCursor(row, col);
                }
            }
        }
    }
}
