const fs = require('fs');
const mockBrowser = require('mock-browser').mocks.MockBrowser;
const fileReader = require('filereader');
const canvas = require("canvas");
const { Blob } = require("buffer");

global.window = mockBrowser.createWindow();
global.document = window.document;
global.navigator = window.navigator;
global.self = global;
global.HTMLCollection = window.HTMLCollection;
global.getComputedStyle = window.getComputedStyle;
global.FileReader = fileReader;
global.canvas = canvas;

const GC = require('@grapecity/spread-sheets');
require('@grapecity/spread-sheets-io');

GC.Spread.Sheets.LicenseKey = "E197797523415716#B13VrLaVDMCRFM4hzKlFDSaFFNhRXTCN4LmxWaRlmMhZjSnRDMH5WVyJFbwc5USZVYnx4VzEmSkJzMFhWVptkYx4mb7pXSKZXcvkGNzZ4YyEHZqJXN7FlcVZXNGtCcRtiUFZ4bvNXarcVZTp5chpHMyFVS6UWQnR7NDp4Rs5kNsdzQ7E5N4F6Vzlnc8lVdil6KD54VxVEdyh6RCdjdhJnWwlUNXlDMZBjbxdzKp5EOkVFUEJ4cX9kempkQ9JFbpNnbI5mQlJkVOFVctNENthjc8NkZVlEU58kY7dUMThneEVGeHB7SFNjTo3yUD54QPJHdlRWRqJ6brgVUIRDW9VlYQV4aJtUOWxWRvQjVzpFZjZzLvYVeZhlbwlzTaFXZYRFaD9ma9o5dz3UV094UxJTW42CRaZVQJd6a5d4UwpldyZnSMNXZ6QVQ5MEcJFjR4EnaJ3kSQhmQiojITJCLiIURCNDMDFkI0ICSiwCM8gjM9ITOwQTM0IicfJye#4Xfd5nIXR5QaJiOiMkIsIiNx8idgMlSgQWYlJHcTJiOi8kI1tlOiQmcQJCLigzMxADOwACMzATMzIDMyIiOiQncDJCLiMXduMXdpN6cl5mLqwCcq9yc5l6YzVWbuoCLvlmLzVXajNXZt9iKs46bj9yc5l6YzVWbuoCLytmLvNmLzVXajNXZt9iKsAnau26YuMXdpN6cl5mLqwSbvNmL6VGZ9RXajVGchJ7ZuoCLuNmLt36YukHdpNWZwFmcn9iKs46bj9Se4l6YlBXYydmLqwicr9ybj9Se4l6YlBXYydmLqwCcq9ybj9Se4l6YlBXYydmLqIiOiMXbEJCLiMVVJN4UF5kI0ISYONkIsUWdyRnOiwmdFJCLiYTM7UTM4MjM5cTO7cTOxIiOiQWSiwSfdJCdlVGaTRncvBXZSJCLiQXZlh6U4RnbhdkIsISZsJWYUR7b6lGUislOicGbmJCLlNHbhZmOiI7ckJye0ICbuFkI1pjIEJCLt2IP"


try {
	var wb = new GC.Spread.Sheets.Workbook();
	const data = fs.readFileSync('./export.sjs');
	const blob = new Blob([data.buffer], { type: "application/zip" });
	blob.name = "export.sjs";
	blob.stream = fs.createReadStream('./export.sjs');
	wb.open(blob, function () {
		let sheet = wb.getActiveSheet();
		console.log('-------load sjs file-------');
		console.log(sheet.name());
		console.log(sheet.getValue(3, 4));
	}, function (e) {
		console.log(e); // error callback
	}, {
		includeUnusedStyles: false
	});

	var wb1 = new GC.Spread.Sheets.Workbook();
	const data1 = fs.readFileSync('./blank.xlsx');
	const blob1 = new Blob([data1.buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
	blob1.name = "blank.xlsx";
	blob1.stream = fs.createReadStream('blank.xlsx');
	wb1.import(blob1, function () {
		console.log('-------load excel file---------');
		let sheet = wb1.getActiveSheet();
		console.log(sheet.name());
		console.log(sheet.getArray(0, 0, 3, 1));
	}, function (msg) {
		console.log(msg); // error callback
	}, {
		fileType: GC.Spread.Sheets.FileType.excel,
	});
} catch (e) {
	console.error("** Error manipulating spreadsheet **");
	console.error(e);
}