﻿using C1.Web.Wijmo.Controls.C1GridView;
using System;
using System.Data;
using System.Web.UI;

namespace GridView_Pagination
{
    public partial class _Default : Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        private void BindGrid()
        {
            // Generate dummy data with many columns to test horizontal scroll
            DataTable dt = new DataTable();
            dt.Columns.Add("ID");
            dt.Columns.Add("PARAM");
            dt.Columns.Add("VALUE");
            dt.Columns.Add("Name");
            dt.Columns.Add("Product");
            dt.Columns.Add("Region");
            dt.Columns.Add("Status");
            dt.Columns.Add("Date");
            dt.Columns.Add("Total");

            for (int i = 1; i <= 50; i++)
            {
                dt.Rows.Add(i, i, i, "Customer " + i, "Very Long Product Description " + i,
                            "North America", "Shipped", DateTime.Now.ToShortDateString(), "$500.00");
            }

            ConfigurationParamGrid.DataSource = dt;
            ConfigurationParamGrid.DataBind();
        }

        protected void ConfigurationParamGrid_Filtering(object sender, C1GridViewFilterEventArgs e)
        {
            BindGrid();
        }

        protected void ConfigurationParamGrid_RowCommand(object sender, C1GridViewCommandEventArgs e)
        {

        }

        protected void ConfigurationParamGrid_Sorting(object sender, C1GridViewSortEventArgs e)
        {

        }

        protected void ConfigurationParamGrid_Sorted(object sender, EventArgs e)
        {

        }

        protected void ConfigurationParamGrid_PageIndexChanging(object sender, C1GridViewPageEventArgs e)
        {
            ConfigurationParamGrid.PageIndex = e.NewPageIndex;
            BindGrid();
        }

        protected void ConfigurationParamGrid_RowDataBound(object sender, C1GridViewRowEventArgs e)
        {

        }
    }
}