using C1.Excel;
using C1.Win.FlexGrid;
using System.Diagnostics;

namespace FlexGrid_ExportMultipleGrid
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            int cnt = 0;
            foreach (C1FlexGrid grid in new C1FlexGrid[] { c1FlexGrid1, c1FlexGrid2, c1FlexGrid3 })
            {
                cnt++;
                grid.Cols.Count = 4; grid.Rows.Count = 14;
                for (int r = 0; r < grid.Rows.Count; r++)
                    for (int c = grid.Cols.Fixed; c < grid.Cols.Count; c++)
                        if (r >= grid.Rows.Fixed)
                            grid[r, c] = $"grid-{cnt} ({r}, {c})";
                        else if (r == 0)
                            grid[r, c] = $"grid-{cnt} header-{c}";
                grid.AutoSizeCols();

            }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            //c1FlexGrid1.SaveExcel("test.xlsx", FileFlags.IncludeFixedCells); 
            ExportMultipleFlexGrids([c1FlexGrid1, c1FlexGrid2, c1FlexGrid3], "test.xlsx");
            new Process()
            {
                StartInfo =
                {
                    UseShellExecute = true,
                    FileName = "test.xlsx"
                }
            }.Start();
        }

        //exporting in one sheet stacked horizontally
        private void ExportMultipleFlexGrids(C1FlexGrid[] grids, string filePath)
        {
            C1XLBook book = new C1XLBook();
            XLSheet sheet = book.Sheets[0];
            sheet.Name = "Export";

            int startCol = 0;

            foreach (var grid in grids)
            {
                ExportGridHorizontally(grid, sheet, startCol);

                // Move start column rightwards for next grid
                startCol += grid.Cols.Count + 1; // 2-column spacing
            }

            // Freeze first row and first column
            sheet.Rows.Frozen = 1;
            sheet.Columns.Frozen = 1;

            // Save
            book.Save(filePath);
        }

        private void ExportGridHorizontally(C1FlexGrid grid, XLSheet sheet, int startCol)
        {
            for (int r = 0; r < grid.Rows.Count; r++)
            {
                for (int c = 0; c < grid.Cols.Count; c++)
                {
                    var cell = sheet[r, startCol + c];

                    var value = grid[r, c];
                    cell.Value = value;
                }
            }
        }
    }
}
