﻿Imports C1.FlexMap

Public Class Form1

    Dim _layer As New C1.Win.Map.VectorLayer

    Public Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        'Adding TileSource and VectorLayer
        C1Map1.TileLayer.TileSource = New C1.Win.Map.VirtualEarthHybridSource()
        C1Map1.Layers.Add(_layer)

        'Adding Mark (latitude, longitude)
        AddMark(45.469588, 9.179472)
    End Sub

    Private Sub AddMark(lat As Double, lon As Double)
        Dim mark = New C1.Win.Map.VectorPlacemark()
        _layer.Items.Add(mark)

        'GeoPoint constructor accepts (X, Y) as paramaters, which translates to (longitude, latitude)
        mark.Geometry = New GeoPoint(lon, lat)

        mark.Marker.Size = New SizeF(20, 27.32F)
        mark.Marker.Shape = MarkerShape.Custom
        mark.Marker.CustomShape = New MarkShape()
        mark.Style.Stroke.Color = Color.DarkGray
        mark.Style.Stroke.Width = 1
        mark.Style.BackColor = Color.Red
    End Sub

End Class
