﻿Imports C1.Win.Map
Imports System.Drawing.Drawing2D

''' <summary>
''' Custom pin shape for the markers
''' </summary>
Public Class MarkShape
    Inherits CustomShape

    Public Overrides Function GetDrawingBounds(g As Graphics, bounds As RectangleF, style As Style) As RectangleF
        bounds.Y -= bounds.Height / 2
        Return bounds
    End Function

    Public Overrides Function IsVisible(g As Graphics, bounds As RectangleF, point As PointF, style As Style) As Boolean
        Using path = CreateBaloon(bounds)
            Return path.IsVisible(point)
        End Using
    End Function

    Public Overrides Sub Draw(g As Graphics, bounds As RectangleF, style As Style)
        Using path = CreateBaloon(bounds)

            Using brush = New SolidBrush(style.BackColor)
                g.FillPath(brush, path)
            End Using

            Using pen = New Pen(style.Stroke.Color, style.Stroke.Width)
                g.DrawPath(pen, path)
            End Using

            Dim rect = New RectangleF(bounds.Location, New SizeF(20, 20))

            Using brush = New SolidBrush(style.ForeColor)

                Using sf = New StringFormat()
                    sf.Alignment = StringAlignment.Center
                    sf.LineAlignment = StringAlignment.Center
                End Using
            End Using
        End Using
    End Sub

    Private Function CreateBaloon(bounds As RectangleF) As GraphicsPath
        Dim path = New GraphicsPath()
        Dim rect = New RectangleF(bounds.Location, New SizeF(20, 20))
        path.AddArc(rect, 120, 300)
        rect = New RectangleF(bounds.Right - 10, bounds.Bottom - 10, 20, 20)
        path.AddArc(rect, -120, -60)
        rect = New RectangleF(bounds.Left - 10, bounds.Bottom - 10, 20, 20)
        path.AddArc(rect, 0, -60)
        Return path
    End Function
End Class
