﻿using C1.WPF;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ComboBoxBinding
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window, INotifyPropertyChanged
    {
        private ObservableCollection<Month> _months;
        public ObservableCollection<Month> Months 
        {
            get
            { return _months; }
            set
            {
                _months = value;
                OnPropertyRaised("Months");
            }
        }

        public MainWindow()
        {
            InitializeComponent();
            Months = GetMonths();

        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyRaised(string propertyname)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyname));
            }
        }

        public ObservableCollection<Month> GetMonths()
        {
            var months = new ObservableCollection<Month>();
            months.Add(new Month() { SNo = 1, Name = "Janauary" });
            months.Add(new Month() { SNo = 2, Name = "February" });
            months.Add(new Month() { SNo = 3, Name = "March" });
            months.Add(new Month() { SNo = 4, Name = "April" });
            months.Add(new Month() { SNo = 5, Name = "May" });
            months.Add(new Month() { SNo = 6, Name = "June" }); 
            months.Add(new Month() { SNo = 7, Name = "July" });
            months.Add(new Month() { SNo = 8, Name = "August" });
            months.Add(new Month() { SNo = 9, Name = "September" });
            months.Add(new Month() { SNo = 10, Name = "October" });
            months.Add(new Month() { SNo = 11, Name = "November" });
            months.Add(new Month() { SNo = 12, Name = "December" });

            return months;
        }

        private void C1ComboBox_SelectedIndexChanged(object sender, C1.WPF.PropertyChangedEventArgs<int> e)
        {
            var value = ((sender as C1ComboBox).SelectedItem as Month).Name;
        }
    }



    public class Month : INotifyPropertyChanged
    {
        private int _sNo;

        public int SNo
        {
            get
            { return _sNo; }
            set
            {
                _sNo = value;
                OnPropertyRaised("SNo");
            }
        }

        private string _name;

        public string Name
        {
            get
            { return _name; }
            set
            {
                _name = value;
                OnPropertyRaised("Name");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;
        private void OnPropertyRaised(string propertyname)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyname));
            }
        }
    }
}
