﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace reorderCol
{
    public class Product : INotifyPropertyChanged
    {
        static Random _rnd = new Random();
        static string[] _names = "Macko|Surfair|Pocohey|Studeby".Split('|');
        static string[] _lines = "Computers|Washers|Stoves".Split('|');
        static string[] _colors = "Red|Green|Blue|White".Split('|');

        private string _name;
        private DateTime _introduced;

        public string Line
        {
            get { return (string)GetValue("Line"); }
            set { SetValue("Line", value); }
        }

        public string Color
        {
            get { return (string)GetValue("Color"); }
            set { SetValue("Color", value); }
        }

        Dictionary<string, object> _values = new Dictionary<string, object>();

        object GetValue(string p)
        {
            object value;
            _values.TryGetValue(p, out value);
            return value;
        }
        void SetValue(string p, object value)
        {
            if (!object.Equals(value, GetValue(p)))
            {
                _values[p] = value;
                OnPropertyChanged(p);
            }
        }
        protected virtual void OnPropertyChanged(string p)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(p));
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public string Name
        {
            get { return _name; }
            set
            {
                if (value != this._name)
                {
                    this._name = value;
                    NotifyPropertyChanged();
                }
            }
        }
        public DateTime Introduced
        {
            get { return _introduced; }
            set
            {
                if (value != this._introduced)
                {
                    this._introduced = value;
                    NotifyPropertyChanged();
                }
            }
        }


        private void NotifyPropertyChanged([CallerMemberName] String propertyName = "")
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        public Product()
        {
            Name = _names[_rnd.Next() % _names.Length];
            Color = _colors[_rnd.Next() % _colors.Length];
            Line = _lines[_rnd.Next() % _lines.Length];
        }
    }
}
