﻿Imports System.Timers
Imports C1.Win.C1FlexGrid

Public Class Form1

    Private searchBuffer As String = String.Empty
    Private resetTimer As Timer

    Public Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        'setting columns
        C1FlexGrid1.Cols.Count = 2
        C1FlexGrid1.Cols(1).DataType = GetType(Integer)

        'setting datamap
        C1FlexGrid1.Cols(1).DataMap = New Dictionary(Of Integer, String) From {
            {1, "MNO"},
            {2, "MAM"},
            {3, "ABC"}
        }

        'Setup a timer
        resetTimer = New Timer(500)
        AddHandler resetTimer.Elapsed, AddressOf ResetTimer_Elapsed
        resetTimer.AutoReset = False

        'handle SetupEditor and LeaveEdit events
        AddHandler C1FlexGrid1.SetupEditor, AddressOf C1FlexGrid1_SetupEditor
        AddHandler C1FlexGrid1.LeaveEdit, AddressOf C1FlexGrid1_LeaveEdit

    End Sub

    Private Sub C1FlexGrid1_SetupEditor(sender As Object, e As RowColEventArgs)
        If e.Col <> 1 Then Return

        Dim cmb = TryCast(C1FlexGrid1.Editor, ComboBox)
        If cmb IsNot Nothing Then

            'handle the KeyPress event of the ComboBox
            AddHandler cmb.KeyPress, AddressOf cmb_KeyPress

        End If
    End Sub

    Private Sub C1FlexGrid1_LeaveEdit(sender As Object, e As RowColEventArgs)
        If e.Col <> 1 Then Return

        Dim cmb = TryCast(C1FlexGrid1.Editor, ComboBox)
        If cmb IsNot Nothing Then

            'remove the KeyPress event from the ComboBox
            RemoveHandler cmb.KeyPress, AddressOf cmb_KeyPress

        End If
    End Sub

    Private Sub cmb_KeyPress(sender As Object, e As KeyPressEventArgs)

        Dim ComboBox1 = TryCast(sender, ComboBox)

        resetTimer.Stop()
        searchBuffer &= e.KeyChar
        resetTimer.Start()

        'handle the search and selection manually
        For i As Integer = 0 To ComboBox1.Items.Count - 1
            Dim itemText As String = ComboBox1.GetItemText(ComboBox1.Items(i))
            If itemText.StartsWith(searchBuffer, StringComparison.InvariantCultureIgnoreCase) Then
                ComboBox1.SelectedIndex = i
                Exit For
            End If
        Next

        e.Handled = True
    End Sub

    Private Sub ResetTimer_Elapsed(sender As Object, e As ElapsedEventArgs)

        'reset the buffer after timer is elapsed
        searchBuffer = String.Empty
    End Sub

End Class
