using System.Text;
using System.Xml.Linq;

namespace Editor_SpellChecker
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            c1Editor1.C1EditorReady += C1Editor1_C1EditorReady;
        }

        private void C1Editor1_C1EditorReady(object? sender, EventArgs e)
        {
            var text = File.ReadAllText("tesla.html");

            text = SetSpellCheck(text, false);

            var bytes = Encoding.UTF8.GetBytes(text);
            var stream = new MemoryStream(bytes);
            c1Editor1.LoadDocumentAsync(stream);
        }

        string SetSpellCheck(string text, bool enable)
        {
            XDocument doc = XDocument.Parse(text);

            // Default namespace for XHTML
            XNamespace ns = "http://www.w3.org/1999/xhtml";

            XElement? body = doc.Root?.Element(ns + "body");
            if (body != null)
            {
                body.SetAttributeValue("spellcheck", enable);
            }

            return doc.ToString();
        }
    }
}
