﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Windows.Forms;
using C1.C1Schedule;
using C1.Win.C1Schedule;

namespace ScheduleContactMove
{
    public partial class Form1 : Form
    {
        ContextMenuStrip groupHeaderMenu;

        public Form1()
        {
            InitializeComponent();

            #region old code

            //Loading sample schedule
            c1Schedule1.DataStorage.Import("..\\..\\C1Schedule.xml", FileFormatEnum.XML);

            //Group by "Contact"
            c1Schedule1.GroupBy = "Contact";
            c1Schedule1.GroupPageSize = 3;

            #endregion

            //Handle event
            c1Schedule1.BeforeContextMenuShow += C1Schedule1_BeforeContextMenuShow;
        }

        private void C1Schedule1_BeforeContextMenuShow(object sender, BeforeContextMenuShowEventArgs e)
        {
            //When right click on group header
            if(e.SelectionType == SelectionType.GroupHeader)
            {
                //show custom ContextMenu
                if (groupHeaderMenu is null)
                {
                    groupHeaderMenu = new ContextMenuStrip();
                    groupHeaderMenu.Items.Add("Move Right", null, (s,ea) => moveRightToolStripMenuItem.PerformClick());
                }
                groupHeaderMenu.Show(MousePosition);
            }
        }

        private void reOrderContactsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Enclose the code between BeginUpdate and EndUpdate method calls
            c1Schedule1.BeginUpdate();
            var selectedContact = c1Schedule1.SelectedGroupItem;
            //Get the contacts
            var contacts = c1Schedule1.DataStorage.ContactStorage.Contacts;
            //Reorder them as per your requirement
            var reorder = contacts.OrderBy(cont => cont.Text).ToArray();
            //clear the contacts
            contacts.Clear();
            //add reordered contacts
            contacts.AddRange(reorder);


            c1Schedule1.EndUpdate();
        }

        private void moveRightToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Enclose the code between BeginUpdate and EndUpdate method calls
            c1Schedule1.BeginUpdate();
            var selectedContact = c1Schedule1.SelectedGroupItem;
            //Get the contacts
            var contacts = c1Schedule1.DataStorage.ContactStorage.Contacts;

            //Reorder the contacts
            var reorder = contacts.ToArray();
            int selectInd = Array.IndexOf(reorder, selectedContact.Owner);
            if (selectInd == reorder.Length - 1) return;
            int switchInd = selectInd + 1;
            var contact = reorder[selectInd];
            var contact2 = reorder[switchInd];
            reorder[selectInd] = null;
            reorder[switchInd] = null;
            reorder[switchInd] = contact;
            reorder[selectInd] = contact2;


            //clear the contacts
            contacts.Clear();
            //add reordered contacts
            contacts.AddRange(reorder);


            c1Schedule1.EndUpdate();
        }
    }
}
