using C1.Chart;
using C1.Win.Chart;
using C1.Win.Chart.Interaction;

namespace FlexChart_AnnotationLine
{
    public partial class Form1 : Form
    {
        FlexChart _chart;
        YLine[] _yLines;
        public Form1()
        {
            InitializeComponent();

            var rnd = new Random();
            //chart
            var data = Enumerable.Range(1, 100).Select(i => new Point(i, rnd.Next(10, 100))).ToList();
            this.Controls.Add(_chart = new FlexChart()
            {
                Dock = DockStyle.Fill,
                DataSource = data,
                BindingX = "X",
                Binding = "Y",
                Series =
                {
                    new Series()
                },
                AxisY =
                {
                    Min = 0,
                    Max = 110,
                    MajorUnit = 10
                }
            });

            //values for marking
            int min = int.MaxValue, max = int.MinValue, sum = 0;
            foreach (Point pt in data)
            {
                min = Math.Min(min, pt.Y);
                max = Math.Max(max, pt.Y);
                sum += pt.Y;
            }
            float avg = (float)sum / data.Count;

            _yLines =
            [
                new YLine(max, $"Maximum: {max}", Color.Red),
                new YLine(avg, $"Average: {avg}", Color.Yellow),
                new YLine(min, $"Minimum: {min}", Color.LightGreen)
            ];

            _chart.Rendered += Chart_Rendered;

            //scrollbar
            new AxisScrollbar(_chart.AxisX);
        }

        private void Chart_Rendered(object? sender, RenderEventArgs e)
        {
            if (_yLines != null)
                foreach (var line in _yLines)
                    RenderLine(line, e.Engine);
        }

        void RenderLine(YLine line, IRenderEngine engine)
        {
            var plotRect = _chart.PlotRect;

            // data coordinate -> pixel
            var y = _chart.AxisY.Convert(line.Y);

            // draw line
            engine.SetStroke(line.Color.ToArgb());
            engine.DrawLine(plotRect.X, y, plotRect.Right, y);

            // draw text
            var text = line.Text;
            var sz = engine.MeasureString(text);
            engine.SetFill(Color.Black.ToArgb());
            engine.DrawString(text, new C1.Chart._Point(plotRect.X + plotRect.Width / 2 - sz.Width / 2, y - sz.Height));
        }

        class YLine
        {
            public float Y { get; set; }
            public Color Color { get; set; }
            public string Text { get; set; }

            public YLine(float y, string text = "")
            {
                Y = y;
                Text = text;
                Color = Color.Black;
            }
            public YLine(float y, string text, Color color)
            {
                Y = y;
                Text = text;
                Color = color;
            }
        }
    }
}
