﻿(function (global) {
    SystemJS.config({
        transpiler: './plugin-typescript.js',
        typescriptOptions: {
            "target": "es2022",
            "module": "system",
            "emitDecoratorMetadata": true,
            "experimentalDecorators": true,
        },
        baseURL: './node_modules/',
        meta: {
            'typescript': {
                "exports": "ts"
            },
            '*.css': { loader: 'systemjs-plugin-css' }
        },
        packageConfigPaths: [
            './node_modules/*/package.json',
            "./node_modules/@grapecity/*/package.json"
        ],
        map: {
            'typescript': 'typescript/lib/typescript.js',
            "@grapecity/spread-sheets": "@grapecity/spread-sheets/dist/gc.spread.sheets.all.min.js",
            "@grapecity/spread-sheets/styles/gc.spread.sheets.excel2016colorful.css": "@grapecity/spread-sheets/styles/gc.spread.sheets.excel2016colorful.css",
        },
        // packages tells the System loader how to load when no filename and/or no extension
        packages: {
            "./src": {
                defaultExtension: 'ts'
            },
            "node_modules": {
                defaultExtension: 'js'
            },
        }
    });
})(this);
