﻿using C1.C1Report;
using C1.Web.Wijmo.Controls.C1ReportViewer;
using System;
using System.Data;
using System.Drawing;
using System.Web.UI;

namespace Report_Sample
{
    public partial class _Default : Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            C1ReportViewer.RegisterDocument("SampleReport", GetReport);
        }

        private C1Report GetReport()
        {
            //var report = new C1Report();
            //see https://developer.mescius.com/componentone/docs/webforms/online-reportviewer/NoteonC1ReportC1PrintDocumentLicensing.html
            var report = C1ReportViewer.CreateC1Report();

            report.Load(Server.MapPath("~/C1Report/SampleC1Report.xml"), "SampleReport");
            report.DataSource.Recordset = new DataTable()
            {
                Columns = { "Val" },
                Rows =
                {
                    {"val-1" },
                    {2 },
                    {"Val-3" }
                }
            };
            report.Fields["logo"].Picture = Image.FromFile(Server.MapPath("~/Images/c1.png"));
            report.Fields["logo"].PictureScale = PictureScaleEnum.Scale;

            return report;
        }
    }
}