﻿Imports System.Data.OleDb

Public Class Form1
    Sub New()
        ' This call is required by the designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.

        C1FlexViewer1.DocumentSource = C1FlexReport1
        C1FlexReport1.Load("./SampleReport.flxr", "Appointees Report")

        'using connection string
        C1FlexReport1.DataSources.Add(New C1.Win.FlexReport.DataSource With {
            .Name = "ConnectionString",
            .DataProvider = C1.Win.FlexReport.DataProvider.OLEDB,
            .ConnectionString = GetConnectionString(),
            .RecordSource = "select * from Appointees",
            .RecordSourceType = C1.Win.FlexReport.RecordSourceType.Text
        })

        Dim adapter = New OleDbDataAdapter("select * from Appointees", GetConnectionString())

        'using dataset
        Dim dataSet = New DataSet
        adapter.Fill(dataSet)
        C1FlexReport1.DataSources.Add(New C1.Win.FlexReport.DataSource With {
            .Name = "DataSet",
            .Recordset = dataSet.Tables.Item(0)
        })

        'using datatable
        Dim dataTable = New DataTable
        adapter.Fill(dataTable)
        C1FlexReport1.DataSources.Add(New C1.Win.FlexReport.DataSource With {
            .Name = "DataTable",
            .Recordset = dataTable
        })

        'using .xsd file
        dataSet.WriteXml("DataFile.xsd") 'Creating XSD file for the sample
        Dim dataSetFromXSD = New DataSet
        dataSetFromXSD.ReadXml("DataFile.xsd")
        C1FlexReport1.DataSources.Add(New C1.Win.FlexReport.DataSource With {
            .Name = "DataFromXSD",
            .Recordset = dataSetFromXSD.Tables.Item(0)
        })

        C1FlexReport1.DataSourceName = "ConnectionString"
    End Sub

    Shared Function GetConnectionString() As String

        Return $"provider=Microsoft.ACE.OLEDB.12.0;data source={Environment.GetFolderPath(Environment.SpecialFolder.Personal)}\\ComponentOne Samples\\Common\\c1nwind.mdb;"

    End Function


End Class
