﻿using C1.Blazor.Grid;
using C1.Blazor.Input;
using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;

public class ValidationCellFactory : GridCellFactory
{
    private readonly IJSRuntime _js;

    // Use a constructor to pass the JSRuntime
    public ValidationCellFactory(IJSRuntime js)
    {
        _js = js;
    }

    protected override RenderFragment GetCellEditorFragment(GridCellRange range, Action<ComponentBase> editorCreated)
    {
        string errorSpanId = $"err_{range.Row}_{range.Column}";

        var baseEditor = base.GetCellEditorFragment(range, (editor) => {
            editorCreated?.Invoke(editor);

            if (Grid.Columns[range.Column].Binding == "Val_01_to_10" && editor is C1TextBox textbox)
            {
                textbox.TextChanged = EventCallback.Factory.Create<string>(this, async (val) =>
                {
                    bool isInvalid = !(int.TryParse(val, out int result) && result >= 1 && result <= 10);

                    // Call the JS function
                    await _js.InvokeVoidAsync("ToggleValidationError", errorSpanId, isInvalid);
                });
            }
        });

        return builder =>
        {
            builder.OpenElement(0, "div");
            builder.AddAttribute(1, "style", "display: flex; flex-direction: column; width: 100%; height: 100%; justify-content: center; overflow: visible;");
            builder.AddContent(2, baseEditor);

            builder.OpenElement(3, "span");
            builder.AddAttribute(4, "id", errorSpanId);
            builder.AddAttribute(5, "style", "display: none; color: #dc3545; font-size: 10px; font-weight: bold; margin-top: 2px; padding-left: 4px; background: white; pointer-events: none;");
            builder.AddContent(6, "Value must be 1-10");
            builder.CloseElement();

            builder.CloseElement();
        };
    }
}