﻿using C1.C1Schedule;
using System;
using System.Windows.Forms;

namespace ScheduleSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            c1Schedule1.ShowWorkTimeOnly = true;
            c1Schedule1.DataStorage.Import("..\\..\\TestApp.xml", FileFormatEnum.XML);

            c1Schedule1.AppointmentAdded += C1Schedule1_AppointmentAdded;
            c1Schedule1.AppointmentChanged += C1Schedule1_AppointmentChanged;
        }

        bool _changeByCode = false;

        private void C1Schedule1_AppointmentChanged(object sender, AppointmentEventArgs e)
        {
            //If flag
            if (_changeByCode)
            {
                //remove the flag
                _changeByCode = false;

                //ignore the change notification
                return;
            }

            //If not flag, execute AppointmentChanged logic
            Console.WriteLine("AppointmentChanged");
        }

        private void C1Schedule1_AppointmentAdded(object sender, AppointmentEventArgs e)
        {
            Console.WriteLine("AppointmentAdded");

            //Begin Edit
            e.Appointment.BeginEdit();
            
            //Do all updates here - change notfication will not be pushed
            e.Appointment.CustomData = "CustomData";
            e.Appointment.Location = "G4";

            //Set the flag
            _changeByCode = true;

            //End Edit - change notification will be pushed now
            e.Appointment.EndEdit();
        }
    }
}
