import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';
//
import * as wjOdata from '@mescius/wijmo.odata';
import * as wjGrid from '@mescius/wijmo.grid';
import * as wjGridDetail from '@mescius/wijmo.grid.detail';
import '@angular/compiler';
import { Component, enableProdMode, ChangeDetectionStrategy, ɵresolveComponentResources } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { WjGridDetailModule } from '@mescius/wijmo.angular2.grid.detail';
//

const url = 'https://services.odata.org/Northwind/Northwind.svc';
//
@Component({
  standalone: true,
  imports: [WjGridModule, WjGridDetailModule, BrowserModule],
  selector: 'app-component',
  templateUrl: 'src/app.component.html',
})
export class AppComponent {
  categories: wjOdata.ODataCollectionView;
  products: wjOdata.ODataCollectionView;
  private _catToProductMap: Map<string, any> = new Map();

  // DataSvc will be passed by derived classes
  constructor() {
    this.categories = this._getCategories();
    this.products = this._getProducts();
  }

  getProducts(categoryID: string) {
    let categoryProducts = this._catToProductMap.get(categoryID);
    if (!categoryProducts) {
      categoryProducts = this.products.items.filter((product) => product.CategoryID === categoryID);
      this._catToProductMap.set(categoryID, categoryProducts);
    }
    return categoryProducts;
  }

  private _getCategories() {
    return new wjOdata.ODataCollectionView(url, 'Categories', {
      fields: ['CategoryID', 'CategoryName', 'Description'],
    });
  }

  private _getProducts() {
    return new wjOdata.ODataCollectionView(url, 'Products');
  }
}
//

//
enableProdMode();

// Resolve resources (templateUrl, styleUrls etc), After resolution all URLs have been converted into `template` strings.
ɵresolveComponentResources(fetch).then(() => {
  // Bootstrap application
  bootstrapApplication(AppComponent).catch((err) => console.error(err));
});
