import * as wjGrid from '@mescius/wijmo.grid';

export class CustomMergeManager extends wjGrid.MergeManager {
    getMergedRange(panel: wjGrid.GridPanel, r: number, c: number, clip: boolean = true) {
        //
        // create basic cell range
        var rng = new wjGrid.CellRange(r, c);
        //
        let col = panel.columns[c];
        if (col.allowMerging) {

            //
            let crow: wjGrid.GroupRow = panel.rows[r] as wjGrid.GroupRow;
            // expand down
            for (var i = rng.row; i < panel.rows.length - 1; i++) {
                let nrow = i < panel.rows.length - 1 ? panel.rows[i + 1] as wjGrid.GroupRow : null;
                crow = panel.rows[i] as wjGrid.GroupRow;
                if (!nrow || (nrow.level < crow.level) || (nrow.level == crow.level && nrow.level == 0)) break;
                rng.row2 = i + 1;
            }

            // expand up
            for (var i = rng.row; i > 0; i--) {
                let prow = i > 0 ? panel.rows[i - 1] as wjGrid.GroupRow : null;
                crow = panel.rows[i] as wjGrid.GroupRow;
                if (!prow || crow.level < prow.level || (prow.level == crow.level && prow.level == 0)) break;
                rng.row = i - 1;
            }
        }
        //
        // done
        return rng;
    }
}