﻿using GrapeCity.Documents.Pdf;
using GrapeCity.Documents.Pdf.AcroForms;
using GrapeCity.Documents.Text;
using Microsoft.AspNetCore.Mvc;

namespace DsPdfWebApi.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class PdfController : ControllerBase
    {
        private readonly List<Font> fonts;

        public PdfController()
        {
            fonts = new List<Font>();
        }

        [HttpGet("open")]
        public IActionResult OpenPdf()
        {
            // Load the PDF from file
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "wwwroot", "Assets", "570BA 179-2023.PDF");

            if (!System.IO.File.Exists(filePath))
                return NotFound(new { message = "PDF file not found.", path = filePath });

            var doc = new GcPdfDocument();

            using var stream = System.IO.File.OpenRead(filePath);
            doc.Load(stream);

            for (int i = 0; i < doc.AcroForm.Fields.Count; i++)
            {
                Field field = doc.AcroForm.Fields[i];
                PrepareField(ref field);
            }

            // Extract info (e.g., page count, fonts)
            var result = new
            {
                FileName = "570BA 179-2023.pdf",
                PageCount = doc.Pages.Count,
                Fonts = fonts.Select(font => font?.FontFamilyName)
            };

            return Ok(result);
        }

        private void PrepareField(ref Field pdfField)
        {
            if (pdfField.Widgets == null || pdfField.Widgets.Count < 1)
            {
                if (pdfField.Children != null && pdfField.Children.Count > 0)
                {
                    foreach (var child in pdfField.Children)
                    {
                        var refChild = child;
                        PrepareField(ref refChild);
                    }
                }
                return;
            }
            foreach (var widget in pdfField.Widgets)
            {
                var fieldFont = widget.DefaultAppearance.Font;
                fonts.Add(fieldFont);
            }
        }
    }
}