import { Component } from '@angular/core';
import 'wijmo/styles/wijmo.css';
import * as wjcGrid from 'wijmo/wijmo.grid';

@Component({
  selector: 'app-hello',
  template: `
    <div class="hello-container">
      <h2>Hello Component</h2>
      <p>This is a sample component in Angular 4</p>
      <div>
        <wj-combo-box [itemsSource]="data" [isEditable]="true" [selectedValuePath]="'id'" [displayMemberPath]="'name'"></wj-combo-box>
      </div>
      <br><br>
      <wj-flex-grid [itemsSource]="data"></wj-flex-grid>
      
    </div>
  `,
  styles: [`
    .hello-container {
      margin: 20px;
      padding: 20px;
      border: 1px solid #ccc;
      border-radius: 4px;
    }
    input {
      padding: 8px;
      margin: 10px 0;
      border: 1px solid #ddd;
      border-radius: 4px;
    }
  `]
})
export class HelloComponent {
  name: string = '';
  data = [
    { id: 1, name: 'John Doe', country: 'USA' },
    { id: 2, name: 'Jane Doe', country: 'Canada' },
    { id: 3, name: 'Alice', country: 'UK' },
    { id: 4, name: 'Bob', country: 'Australia' },
    { id: 5, name: 'Charlie', country: 'China' }
  ];
} 