﻿Imports C1.WPF.DataGrid.Summaries
Imports System
Imports System.Windows
Imports System.Windows.Threading

Namespace DataGridAggregates

    ''' <summary>
    ''' Interaction logic for MainWindow.xaml
    ''' </summary>
    Partial Public Class MainWindow
        Inherits Window

        Public Sub New()
            Me.InitializeComponent()

            Me.dataGrid.ItemsSource = DataService.GenerateProducts()

            Me.dataGrid.GroupBy(Me.dataGrid.Columns("Category"), Me.dataGrid.Columns("SubCategory"))

            AddHandler Me.dataGrid.Loaded, AddressOf dataGrid_Loaded

        End Sub

        Private Sub dataGrid_Loaded(sender As Object, e As RoutedEventArgs)

            Dispatcher.BeginInvoke(Sub()
                                       Dim aggregates = New DataGridAggregatesCollection From {New DataGridAggregateSum()}
                                       DataGridAggregate.SetAggregateFunctions(Me.dataGrid.Columns("Sales"), aggregates)
                                   End Sub)
        End Sub
    End Class
End Namespace
