﻿Imports C1.Chart
Imports C1.Win.Chart

Public Class Form1

    Public Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        'clear existing series
        FlexChart1.Series.Clear()

        'create new series
        Dim series1 = New Series With {
                              .Binding = "Y",
                              .BindingX = "X",
                              .ChartType = ChartType.Column}

        'customize its style
        series1.Style.Fill = Brushes.DarkBlue

        'handle SymbolRendering event for column type chart
        AddHandler series1.SymbolRendering, AddressOf series1_SymbolRendering

        'create new series and customize style
        Dim series2 = New Series With {
                              .Binding = "Y",
                              .BindingX = "X",
                              .ChartType = ChartType.Line}
        series2.Style.Stroke = Brushes.Red

        'add series and set datasource
        FlexChart1.Series.Add(series1)
        FlexChart1.Series.Add(series2)
        FlexChart1.DataSource = GetSeriesData()

    End Sub

    Private Sub series1_SymbolRendering(sender As Object, e As RenderSymbolEventArgs)

        'get the data point
        Dim point = CType(e.Item, PointF)

        'check your logic and set the color for specific data point
        If point.Y = 30 Then
            e.Engine.SetFill(Brushes.LimeGreen)
        End If

    End Sub

    'sample data for chart
    Private Function GetSeriesData() As Object
        Dim data = New List(Of PointF)
        For index = 1 To 60
            data.Add(New PointF(index, index))
        Next
        Return data
    End Function
End Class
