﻿using C1.Web.Wijmo.Controls.C1GridView;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace GridView_Pagination
{
    public partial class _Default : Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        private void BindGrid()
        {
            // Generate dummy data with many columns to test horizontal scroll
            DataTable dt = new DataTable();
            dt.Columns.Add("ID");
            dt.Columns.Add("Name");
            dt.Columns.Add("Product");
            dt.Columns.Add("Region");
            dt.Columns.Add("Status");
            dt.Columns.Add("Date");
            dt.Columns.Add("Total");

            for (int i = 1; i <= 50; i++)
            {
                dt.Rows.Add(i, "Customer " + i, "Very Long Product Description " + i,
                            "North America", "Shipped", DateTime.Now.ToShortDateString(), "$500.00");
            }

            
            C1GridView1.DataSource = dt;
            C1GridView1.DataBind();
        }

        protected void C1GridView1_PageIndexChanging(object sender, C1GridViewPageEventArgs e)
        {
            // Set the new page index and re-bind
            C1GridView1.PageIndex = e.NewPageIndex;
            BindGrid();
        }

        protected void C1GridView1_Filtering(object sender, C1GridViewFilterEventArgs e)
        {
            // Implementation for your Filter logic
            BindGrid();
        }
    }
}