﻿using C1.Web.Wijmo.Controls.C1GridView;
using System;
using System.Data;
using System.Diagnostics;
using System.Web.UI.WebControls;

namespace WebApplication1
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // Applying the "HorizontalAlign" fix from your first response
                // this.C1GridView1.HorizontalAlign = HorizontalAlign.Left; // Legacy (not compiles)

                foreach (C1Field col in C1GridView1.Columns)
                    col.ItemStyle.HorizontalAlign = HorizontalAlign.Left;

                BindGrid();
            }
        }

        private void BindGrid()
        {
            DataTable dt = GetSampleData();
            C1GridView1.DataSource = dt;
            C1GridView1.DataBind();

            // Set the percentage footer
            SetPercentageFooter(dt);

            // Accessing a column and fixing the "AllowGroup" property (from your first response)
            if (C1GridView1.Columns.Count > 0)
            {
                var col = (C1BoundField)C1GridView1.Columns[0];
                col.Visible = true;

                // col.AllowGroup = false; // Legacy (not compiles)
                col.GroupInfo.Position = GroupPosition.None; // 2025v2 Fix

                // Explicitly setting column horizontal align via code
                col.ItemStyle.HorizontalAlign = HorizontalAlign.Left;
            }
        }

        private void SetPercentageFooter(DataTable dt)
        {
            if (dt != null && dt.Rows.Count > 0 && C1GridView1.FooterRow != null)
            {
                int totalRequests = 0;
                int totalCompletions = 0;

                foreach (DataRow row in dt.Rows)
                {
                    totalRequests += Convert.ToInt32(row["Number of requests"]);
                    totalCompletions += Convert.ToInt32(row["Counted to the end"]);
                }

                double overallPercentage = 0;
                if (totalRequests > 0)
                {
                    overallPercentage = (double)totalCompletions / totalRequests * 100;
                }

                Label lblFooter = C1GridView1.FooterRow.FindControl("lblPercentageFooter") as Label;
                if (lblFooter != null)
                {
                    lblFooter.Text = overallPercentage.ToString("F2");
                }
            }
        }

        private DataTable GetSampleData()
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("Number of requests", typeof(int));
            dt.Columns.Add("Counted to the end", typeof(int));
            dt.Columns.Add("Completion rate", typeof(double));

            dt.Rows.Add(100, 100, 100.00);
            dt.Rows.Add(5, 2, 40.00);
            dt.Rows.Add(100, 80, 80.00);

            return dt;
        }
    }
}