﻿using C1.Maui.Grid;

namespace ConditionalFormattingMauiGrid
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            flexGrid.CellFactory = new MyCellFactory();
            flexGrid.ItemsSource = Customer.GetCustomerList(50);

            flexGrid.CellEditEnded += FlexGrid_CellEditEnded;
        }

        private void FlexGrid_CellEditEnded(object? sender, GridCellEditEventArgs e)
        {
            //if OrderCount column cell was edited
            if (flexGrid.Columns[e.CellRange.Column].ColumnName.Equals("OrderCount"))
            {
                //refresh the OrderTotal column cell of that row as well
                var range = new GridCellRange(e.CellRange.Row, flexGrid.Columns["OrderTotal"].Index);
                flexGrid.Refresh(GridCellType.Cell, range);
            }
        }
    }
}
