﻿using C1.Maui.Grid;

namespace ConditionalFormattingMauiGrid
{
    public class MyCellFactory : GridCellFactory
    {
        public override void PrepareCell(GridCellType cellType, GridCellRange range, GridCellView cell, Thickness internalBorders)
        {

            base.PrepareCell(cellType, range, cell, internalBorders);
            
            //handle for one column
            var orderCountColumn = Grid.Columns["OrderCount"];
            if (cellType == GridCellType.Cell && range.Column == orderCountColumn.Index)
            {
                var cellValue = Grid[range.Row, range.Column] as int?;
                if (cellValue.HasValue)
                {
                    cell.Foreground = cellValue < 50.0 ? Brush.Red : Brush.Green;
                }
            }

            //handle for other column
            var orderTotalColumn = Grid.Columns["OrderTotal"];
            if (cellType == GridCellType.Cell && range.Column == orderTotalColumn.Index)
            {
                var cellValue = Grid[range.Row, orderCountColumn.Index] as int?;
                if (cellValue.HasValue)
                {
                    cell.Foreground = cellValue < 50.0 ? Brush.Red : Brush.Green;
                }
            }
        }
    }
}
