using C1.Win.FlexGrid;
using System.Data;
using System.Diagnostics;

namespace FlexGrid_Sample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            SetupGrid();
        }

        private void SetupGrid()
        {
            // populate grid
            Random rnd = new Random();
            _flex.Rows.Count = 14;
            _flex[0, 1] = "Direction";
            _flex[0, 2] = "Region";
            CellRange rg = _flex.GetCellRange(0, 3, 0, _flex.Cols.Count - 1);
            rg.Data = "Rnd";
            for (int r = 1; r < _flex.Rows.Count; r++)
            {
                _flex[r, 0] = r;
                _flex[r, 1] = (r < 7) ? "Inbound" : "Outbound";
                _flex[r, 2] = (r < 3) ? "North" : (r < 7) ? "South" : (r < 10) ? "East" : "West";
                for (int c = 3; c < _flex.Cols.Count; c++)
                {
                    _flex[r, c] = rnd.Next(1000);
                    _flex.Cols[c].Format = "#,###";
                }
            }

            _flex.Tree.Column = 1;
            _flex.SubtotalPosition = SubtotalPositionEnum.BelowData;
            _flex.HideGroupedColumns = true;

            //adding Footer
            _flex.Footers.Descriptions.Add(new FooterDescription()
            {
                Aggregates =
                {
                    new AggregateDefinition()
                    {
                        Aggregate = AggregateEnum.Sum,
                        Column = _flex.Cols.Count - 1
                    }
                },
                Caption = "Total"
            });


            _flex.AfterSubtotal += Flex_AfterSubtotal;
            _flex.AfterEdit += Flex_AfterEdit;

            UpdateTotals();

            _flex.AutoSizeCols();
        }

        void UpdateTotals()
        {
            for (int c = 3; c < _flex.Cols.Count; c++)
            {
                UpdateTotals(c);
            }
        }

        void UpdateTotals(int col)
        {
            _flex.Subtotal(AggregateEnum.Sum, 0, 1, col, "Department: {0}");
            _flex.Subtotal(AggregateEnum.Sum, 1, 2, col, "Team: {0}");
        }

        private void Flex_AfterEdit(object sender, RowColEventArgs e)
        {
            //Footer total:
            Debug.WriteLine($"Footer Total: {_flex[_flex.Rows.Count - 1, _flex.Cols.Count - 1]}");
            if(e.Col>=3 && e.Row>=_flex.Rows.Fixed)
            {
                UpdateTotals(e.Col);
            }
        }

        private void Flex_AfterSubtotal(object sender, SubtotalEventArgs e)
        {
            Debug.WriteLine($"Level: {e.Level} - Col: {e.TotalOn}\t{e.Function}: {e.AggregateValue}");
        }
    }
}
