let spreadNS = GC.Spread.Sheets;
let config = GC.Spread.Sheets.Designer.DefaultConfig;
let designer, spread;
designer = new spreadNS.Designer.Designer(document.getElementById('ribbonHost'));
spread = designer.getWorkbook();

var sheet = spread.getActiveSheet();


sheet.suspendPaint();

sheet.setRowCount(800);
// 1. Fill 250 points of data in columns A and B
for (let i = 0; i < 800; i++) {
    sheet.setValue(i, 0, i + 1);       // Column A: X values (1, 2, 3, ..., 250)
    sheet.setValue(i, 1, Math.random() * 100); // Column B: Y values (random numbers)
}

// 2. Add a Line Chart using the data from A1:B250
let chart = sheet.charts.add('lineChart800', GC.Spread.Sheets.Charts.ChartType.line,
    100, 50, 800, 400, "A1:B800"
);

// 3. (Optional) Customize the chart a bit
let chartTitle = chart.title();
chartTitle.text = "Chart with 800 Points";
chart.title(chartTitle);


var pieChart = sheet.charts.add('Pie Chart', GC.Spread.Sheets.Charts.ChartType.pie, 500, 50, 800, 500, "A1:B300");
pieChart.title({
    text: "Browser Market Share 300"
});
var pieStyle = pieChart.series().get(0);

sheet.resumePaint();