﻿<%@ Page Title="Home Page" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="GridView_Dialog_Sample._Default" %>

<%@ Register Assembly="C1.Web.Wijmo.Controls.48" Namespace="C1.Web.Wijmo.Controls.C1GridView" TagPrefix="cc1" %>
<%@ Register Assembly="C1.Web.Wijmo.Controls.48" Namespace="C1.Web.Wijmo.Controls.C1Dialog" TagPrefix="cc2" %>

<asp:Content ID="BodyContent" ContentPlaceHolderID="MainContent" runat="server">
    
    <script type="text/javascript">
        function OpenEditParamWindow(id, title) {
            var $dialog = $("#" + id);

            // Try to find the Wijmo widget. If it's not ready, retry in 100ms.
            if ($dialog.data("c1-c1dialog") || $dialog.data("wijmo-c1dialog")) {
                $dialog.c1dialog("open");
                if (title) $dialog.c1dialog("option", "title", title);
            }
            else {
                // Widget not ready? Wait a tiny bit and try again.
                setTimeout(function () {
                    OpenEditParamWindow(id, title);
                }, 100);
            }
        }
    </script>

    <cc1:C1GridView ID="ConfigurationParamGrid" runat="server" 
        AutoGenerateColumns="False" 
        OnRowCommand="ConfigurationParamGrid_RowCommand" 
        OnRowEditing="ConfigurationParamGrid_RowEditing"
        DataKeyNames="ID,PARAM,VALUE">
        <Columns>
            <cc1:C1TemplateField HeaderText="Image Edit">
                <ItemTemplate>
                    <asp:ImageButton ID="ImageButtonEdit" runat="server" 
                        CommandName="EditDetraction" 
                        CommandArgument='<%# Container.DisplayIndex %>'
                        CausesValidation="true"
                        ImageUrl="~/Images/edit.png" 
                        OnCommand="ImageButtonEdit_Command"/>
                </ItemTemplate>
                <ItemStyle Width="30px" />
            </cc1:C1TemplateField>

            <%-- Keep the CommandField for testing, but ensure it has an argument --%>
            <cc1:C1CommandField ShowEditButton="True" ButtonType="Button" HeaderText="Command Edit" />

            <cc1:C1BoundField DataField="PARAM" HeaderText="Parameter" />
            <cc1:C1BoundField DataField="VALUE" HeaderText="Value" />
        </Columns>
    </cc1:C1GridView>

    <%-- Ensure UseEmbeddedVisualStyles is True for testing to avoid CSS issues --%>
    <cc2:C1Dialog ID="EditConfigurationParamWindow" runat="server"
        Title="Edit Parameter"
        ShowOnLoad="False" 
        Modal="True" 
        UseEmbeddedVisualStyles="True"
        MaintainVisibilityOnPostback="False">
        <Content>
            <div style="padding:20px;">
                <p>Parameter: <asp:Label ID="lblParamName" runat="server" /></p>
                <p>Value: <asp:TextBox ID="txtParamValue" runat="server" /></p>
            </div>
        </Content>
    </cc2:C1Dialog>
</asp:Content>