﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using C1.WPF.Docking;
using DockingExplorer.Resources;

namespace DockingExplorer
{
    /// <summary>
    /// Interaction logic for DockControlSaveLayout.xaml
    /// </summary>
    public partial class DockControlBasic : UserControl
    {
        public DockControlBasic()
        {
            InitializeComponent();
            Tag = AppResources.OverviewTag;
            dockControl.ItemDockModeChanged += new EventHandler<C1.WPF.Docking.ItemDockModeChangedEventArgs>(MainWindow.dockControl_ItemDockModeChanged);

            Loaded += delegate
            {
                foreach (var item in dockControl.Items)
                {
                    if (item is C1DockGroup dockGroup)
                    {
                        foreach (var dockItem in dockGroup.Items)
                        {
                            if (dockItem is C1DockTabControl tabControl && tabControl.DockMode == DockMode.Hidden)
                            {
                                tabControl.DockMode = DockMode.Docked;
                            }
                        }
                    }
                    else if (item is C1DockTabControl tabControl && tabControl.DockMode == DockMode.Hidden)
                    {
                        tabControl.DockMode = DockMode.Docked;
                    }
                }
            };

        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            var btn = (Button)sender;
            try
            {
                var tabItem = btn.Parent as C1DockTabItem;
                var tabControl = tabItem.Parent as C1DockTabControl;
                // Get the position of the control relative to the window
                Point positionRelativeToWindow = tabControl.TransformToAncestor(Application.Current.MainWindow)
                                                     .Transform(new Point(0, 0));

                // The positionRelativeToWindow variable now contains the control's position relative to the window
                double x = positionRelativeToWindow.X;
                double y = positionRelativeToWindow.Y;
                C1Window window = new C1Window();
                window.Width = tabControl.ActualWidth /2;
                window.Height = tabControl.ActualHeight /2;
                window.Left = (tabControl.ActualWidth > window.Width) ? (x + (tabControl.ActualWidth - window.Width)/2 ): x;
                window.Top = (tabControl.ActualHeight > window.Height) ? (y + (tabControl.ActualHeight - window.Height) / 2) : y;
                
                window.Tag = x.ToString() + ":" + y.ToString() + ":" + 
                    tabControl.ActualHeight.ToString() + ":" + tabControl.ActualWidth.ToString();
                window.Content = "Hello World!";
                window.Show();
                window.SizeChanged += Window_SizeChanged;

            }
            catch (Exception)
            {

                throw;
            }
        }

        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            var window = sender as C1Window;
            string[] dimParent = window.Tag.ToString().Split(':');
            double XParent = 0, YParent = 0;
            double widthParent=0, heightParent=0;
            
            if (Double.TryParse(dimParent[0], out XParent) && Double.TryParse(dimParent[1], out YParent))
            {
                heightParent = double.Parse(dimParent[2]);
                widthParent = double.Parse(dimParent[3]);
            }
            if (window.Left < XParent)
            {
                window.Left = XParent;
                window.Width = e.PreviousSize.Width;
            }
            if (window.Top < YParent)
            {
                window.Top = YParent;
                window.Height = e.PreviousSize.Height;
            }
            if ((window.Left + e.NewSize.Width) > (XParent + widthParent))
            {
                window.Width = e.PreviousSize.Width;
            }
            if ((window.Top + e.NewSize.Height) > (YParent + heightParent))
            {
                window.Height = e.PreviousSize.Height;
            }
        }

    }
}
