﻿Imports C1.Win.Chart
Imports System
Imports System.Data
Imports System.Data.OleDb
Imports System.Windows.Forms

Namespace ShowMultipleSeries
    Public Partial Class Form1
        Inherits Form
        Public Sub New()
            InitializeComponent()
        End Sub

        Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
            Dim dt As New DataTable()
            Dim connectionString As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" &
                    IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments),
                    "CostHoursDB.mdb") & ";"
            Dim conn As New OleDbConnection(connectionString)
            Dim adapter As New OleDbDataAdapter("SELECT 
                    Postcode,
                    SUM(IIF(Worker = 'Albert', SumHOurs, 0)) AS Albert,
                    SUM(IIF(Worker = 'Gomez', SumHOurs, 0)) AS Gomez,
                    SUM(IIF(Worker = 'Robert', SumHOurs, 0)) AS Robert,
                    SUM(IIF(Worker = 'Jim', SumHOurs, 0)) AS Jim
                FROM Tabelle1
                GROUP BY Postcode", conn)
            adapter.Fill(dt)
            flexChart1.DataSource = dt
            flexChart1.Series.Clear()
            flexChart1.BindingX = "Postcode"
            flexChart1.Series.Add(New Series With {
                .Name = "Albert",
                .Binding = "Albert"
            })
            flexChart1.Series.Add(New Series With {
                .Name = "Gomez",
                .Binding = "Gomez"
            })
            flexChart1.Series.Add(New Series With {
                .Name = "Robert",
                .Binding = "Robert"
            })
            flexChart1.Series.Add(New Series With {
                .Name = "Jim",
                .Binding = "Jim"
            })
            flexChart1.AxisX.Title = "PostCode"
            flexChart1.AxisY.Title = "SumHours"
        End Sub
    End Class
End Namespace
