﻿using C1.Win.C1FlexGrid;
using System;
using System.Linq;
using System.Windows.Forms;

namespace FlexGridNodeMerge
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Setup both grids with same tree
            SetupGrid(c1FlexGridEx1);
            SetupGrid(c1FlexGrid1);

        }
        /// <summary>
        /// Setups sample tree data for the grid
        /// </summary>
        private void SetupGrid(C1FlexGrid grid)
        {
            grid.Tree.Column = 1;
            grid.Cols.Count = 7;
            grid.Rows.Count = 1;
            grid.AllowMerging = AllowMergingEnum.Nodes;

            var colNames = "Ngày, Số, Diễn giải, Đối tượng, Tiến hàng, Tiền VAT".Split(new string[] { ", " }, StringSplitOptions.None).ToList();
            for (int i = 0; i < grid.Cols.Count - 1; i++) grid.Cols[i + 1].Name = grid.Cols[i + 1].Caption = colNames[i];

            var row = grid.Rows.Add();
            row.IsNode = true;
            row.Node.Data = "Parent 1 (Extra text for merging)";
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 1");
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 2");

            row = grid.Rows.Add();
            row.IsNode = true;
            row.Node.Data = "Parent 2";
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 1");
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 2");

            row = grid.Rows.Add();
            row.IsNode = true;
            row.Node.Data = "Parent 3 (Extra text for merging)";
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 1");
            row.Node.AddNode(NodeTypeEnum.LastChild, "Child 2");

            grid.Nodes.OfType<Node>().ToList().ForEach(node => node.Collapsed = true);
        }
    }
}
