using GrapeCity.Documents.Pdf.ViewerSupportApi.Connection;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorPages();
builder.Services.AddCors();
GcPdfViewerHub.ConfigureServices(builder.Services);

//Server side signing implementation
var app = builder.Build();
app.UseCors("WebCorsPolicy");

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");

    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}
app.UseHttpsRedirection();
app.UseStaticFiles();
app.UseRouting();
app.UseAuthorization();

// Suggest using top level route registrations
IApplicationBuilder applicationBuilder = app.UseEndpoints(endpoints =>
{
    _ = endpoints.MapControllers();
});

// Suggest using top level route registrations
app.MapRazorPages();
app.Run();