﻿using C1.Win.C1Input;
using System.Windows.Forms;

namespace SplitButtonDemo
{
    class CustomSplitButton : C1SplitButton
    {
        readonly Timer _timer = new Timer();
        bool _itemClicked = false;

        public CustomSplitButton() : base()
        {
            _timer.Interval = 1;
            _timer.Tick += (s, e) =>
            {
                DroppedDown = true;
                _itemClicked = false;
                _timer.Stop();
            };
        }

        protected override void OnDropDownItemClicked(DropDownItemClickedEventArgs e)
        {
            _itemClicked = true;

            base.OnDropDownItemClicked(e);
        }

        protected override void OnDropDownClosed(DropDownClosedEventArgs e)
        {
            if (_itemClicked) _timer.Start();

            base.OnDropDownClosed(e);
        }
    }
}
