﻿using C1.Win.C1InputPanel;
using System;
using System.Data;
using System.Data.OleDb;
using System.Windows.Forms;

namespace InputPanelBinding
{
    public partial class Form1 : Form
    {
        const string _conn = @"provider=microsoft.jet.oledb.4.0;data source=..\..\SampleDB.mdb;";
        DataTable dt;
        OleDbDataAdapter _adapter;

        public Form1()
        {
            InitializeComponent();

            //BindingSource containing sample data
            FillDataTable();
            BindingSource bs = new BindingSource(dt, string.Empty);

            //Set the Binding for the InputPanel components
            SetInputComponentBinding(inputTextBox1, bs, "First");
            SetInputComponentBinding(inputTextBox2, bs, "Last");
            SetInputComponentBinding(inputTextBox3, bs, "Country");
            SetInputComponentBinding(inputDatePicker1, bs, "Birth");
            SetInputComponentBinding(inputDatePicker2, bs, "Death");
            SetInputComponentBinding(inputDataNavigator1, bs, string.Empty);
        }

        private void SetInputComponentBinding(InputComponent inputTextBox, object dataSource, string dataField)
        {
            //Set DataSource and DataField properties for the InputPanel components
            inputTextBox.DataSource = dataSource;
            inputTextBox.DataField = dataField;
        }

        /// <summary>
        /// Sample data
        /// </summary>
        private void FillDataTable()
        {
            // set up SQL statement
            var rs = $"Select * from Composer";

            // retrieve data into DataSet
            _adapter = new OleDbDataAdapter(rs, _conn);
            dt = new DataTable("Composer");
            _adapter.Fill(dt);
        }

        private void UpdateTable()
        {
            _ = new OleDbCommandBuilder(_adapter) { QuotePrefix = "[", QuoteSuffix = "]" };
            _adapter.Update(dt);
        }

        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            try { UpdateTable(); }
            catch(Exception ex) { MessageBox.Show(ex.Message); }
            finally { base.OnFormClosing(e); }
        }
    }
}
