﻿using C1.Win.C1FlexGrid;
using C1.Win.Ribbon;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace RibbonQatCustomize
{
    public partial class CustomizeQatOrderForm : Form
    {
        RibbonQat _qat;
        string _qatItemNames;

        public string QatItemNames { get { return _qatItemNames; } }

        public CustomizeQatOrderForm(RibbonQat qat, string qatItemNames)
        {
            InitializeComponent();
            _qat = qat;
            _qatItemNames = qatItemNames;

            btnOK.Click += BtnOK_Click;
            btnCancel.Click += BtnCancel_Click;

            c1FlexGrid1.DrawMode = DrawModeEnum.OwnerDraw;
            c1FlexGrid1.OwnerDrawCell += C1FlexGrid1_OwnerDrawCell;
        }

        private void C1FlexGrid1_OwnerDrawCell(object sender, OwnerDrawCellEventArgs e)
        {
            if (e.Measuring) return;

            if(e.Col == 0)
            {
                e.Image = Properties.Resources.drag;
            }
        }

        private void BtnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void BtnOK_Click(object sender, EventArgs e)
        {
            List<string> qatItemNames = new List<string>();
            foreach (Row row in c1FlexGrid1.Rows)
            {
                qatItemNames.Add(row[2].ToString());
            }
            _qatItemNames = string.Join(";", qatItemNames);
            DialogResult = DialogResult.OK;
            this.Close();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            List<string> qatItemNames = _qatItemNames.Split(';').ToList();

            foreach (string itemName in qatItemNames)
            {
                dynamic item1 = _qat.Items[itemName];
                c1FlexGrid1.AddItem(new object[] { string.Empty, item1.Text, itemName });
            }
        }

        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            btnOK.Click -= BtnOK_Click;
            btnCancel.Click -= BtnCancel_Click;
            c1FlexGrid1.OwnerDrawCell -= C1FlexGrid1_OwnerDrawCell;

            base.OnFormClosing(e);
        }
    }
}
