﻿using C1.Win.Ribbon;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RibbonQatCustomize
{
    public partial class Form1 : Form
    {
        RibbonToggleButton _minimizeBtn;
        RibbonItem _removableItem;
        public Form1()
        {
            InitializeComponent();

            BuildCustomContextMenu();
        }

        private void BuildCustomContextMenu()
        {
            c1Ribbon1.ContextMenuPopup += C1Ribbon1_ContextMenuPopup;

            var removeBtn = (RibbonButton)c1Ribbon1.ContextMenuItems.Add("Remove from Quick Access Toolbar");
            removeBtn.Click += (s, e) =>
            {
                if (_removableItem != null && c1Ribbon1.Qat.Items.Contains(_removableItem))
                {
                    c1Ribbon1.Qat.Items.Remove(_removableItem);
                }
            };

            c1Ribbon1.ContextMenuItems.Add(new RibbonSeparator());

            _minimizeBtn = new RibbonToggleButton() { Text = "Minimize the Ribbon" };
            _minimizeBtn.Click += (s, e) => { c1Ribbon1.Minimized = _minimizeBtn.Pressed; };
            c1Ribbon1.ContextMenuItems.Add(_minimizeBtn);
            c1Ribbon1.MinimizedChanged += (s, e) => { _minimizeBtn.Pressed = c1Ribbon1.Minimized; };

            c1Ribbon1.ContextMenuItems.Add(new RibbonSeparator());

            var customizeQatBtn = (RibbonButton)c1Ribbon1.ContextMenuItems.Add("Customize QAT");
            customizeQatBtn.Click += CustomizeQatBtn_Click;
        }

        private void CustomizeQatBtn_Click(object sender, EventArgs e)
        {
            var form = new CustomizeQatOrderForm(c1Ribbon1.Qat, c1Ribbon1.QatItemNames) { StartPosition = FormStartPosition.CenterParent };
            var dialogResult = form.ShowDialog(this);
            if(dialogResult == DialogResult.OK)
            {
                c1Ribbon1.QatItemNames = form.QatItemNames;
            }
        }

        private void C1Ribbon1_ContextMenuPopup(object sender, ContextMenuPopupEventArgs e)
        {
            _removableItem = null;
            if (e.Component is RibbonItem ribbonItem && ribbonItem.Parent.GetType() == typeof(RibbonQat))
            {
                _removableItem = (RibbonItem)e.Component;
                e.UseCustomMenu = true;
                return;
            }
        }
    }
}
