﻿using C1.Win.Chart;
using System;
using System.Linq;
using System.Windows.Forms;

namespace FlexChart48_StackedCharts
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            var rnd = new Random();

            flexChart1.DataSource = Enumerable.Range(1, 10).Select(i =>
            {
                return new
                {
                    X = i,
                    Y1 = 0,
                    Y2 = -1,
                    Y3 = rnd.Next(0, 100),
                    Y4 = rnd.Next(0, 20)
                };
            });
            flexChart1.BindingX = "X";
            flexChart1.AxisY.Max = 1;
            flexChart1.Legend.Position = C1.Chart.Position.Bottom;

            flexChart1.Series.Clear();

            //line series
            flexChart1.Series.Add(new Series()
            {
                Name = "4",
                Binding = "Y1",
                ChartType = C1.Chart.ChartType.Line
            });
            flexChart1.Series.Add(new Series()
            {
                Name = "5",
                Binding = "Y2",
                ChartType = C1.Chart.ChartType.Line
            });

            //column series
            var rightAxis = new Axis()
            {
                Position = C1.Chart.Position.Right
            };
            flexChart1.Series.Add(new Series()
            {
                Name = "1",
                Binding = "Y3",
                AxisY = rightAxis
            });
            flexChart1.Series.Add(new Series()
            {
                Name = "2",
                Binding = "Y4",
                AxisY = rightAxis
                //AxisY = new Axis()
                //{
                //    Position = C1.Chart.Position.Right,
                //    AxisLine = false,
                //    Labels = false,
                //    TickLength = 0
                //}
            });

        }
    }
}
