﻿using C1.Win.C1TrueDBGrid;
using System.Data;
using System.Windows.Forms;

namespace TrueDBGrid_CopyDataFromExcel
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            var dt = new DataTable();
            for (int i = 0; i < 5; i++) dt.Columns.Add();
            for (int i = 0; i < 20; i++) dt.Rows.Add();

            c1TrueDBGrid1.DataSource = dt;

            var myEditor = new MyTextBox();
            foreach (C1DataColumn col in c1TrueDBGrid1.Columns)
                col.Editor = myEditor;

            c1TrueDBGrid1.KeyDown += C1TrueDBGrid1_KeyDown;
        }

        private void C1TrueDBGrid1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.V)
            {
                var text = Clipboard.GetText().Replace("\r\n", "\t");
                if (c1TrueDBGrid1.EditActive && c1TrueDBGrid1.Editor is TextBox textBoxEditor)
                    textBoxEditor.Text = text;
                else
                    c1TrueDBGrid1[c1TrueDBGrid1.Row, c1TrueDBGrid1.Col] = text;
                e.Handled = true;
                e.SuppressKeyPress = true;
            }
        }

        private void toolStripButton1_Click(object sender, System.EventArgs e)
        {
            c1TrueDBGrid1.ExportToDelimitedFile("test.csv", RowSelectorEnum.AllRows, ",");
            MessageBox.Show("Exported to test.csv");
        }
    }
}
