﻿using System.Windows.Forms;

namespace TrueDBGrid_CopyDataFromExcel
{
    public class MyTextBox : TextBox
    {
        private const int WM_PASTE = 0x0302;

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_PASTE)
            {
                if (Clipboard.ContainsText())
                {
                    string clipboardText = Clipboard.GetText();

                    // Modify the clipboard text as needed
                    string modifiedText = ModifyClipboardText(clipboardText);

                    // Insert the modified text at the current selection
                    this.SelectedText = modifiedText;
                }

                // Prevent the default paste behavior
                return;
            }

            base.WndProc(ref m);
        }

        private string ModifyClipboardText(string text)
        {
            // modify text
            return text.Replace("\r\n", "\t");
        }
    }
}
