﻿using C1.Win.C1Document;
using C1.Win.FlexReport;
using System;
using System.Drawing.Printing;
using System.Linq;
using System.Windows.Forms;

namespace FlexReport_Print
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var report = new C1FlexReport();
            report.Load("sampleReport.flxr", "New Report");

            report.Render();
            var printOptions = new C1PrintOptions
            {
                PrinterSettings = new PrinterSettings()
                {
                    PrinterName = "Microsoft Print to PDF"
                },
                PageSettings = new PageSettings
                {
                    Landscape = false,
                    Margins = new Margins(0, 0, 0, 0),
                    //PaperSize = new PaperSize("A4", 827, 1169)
                },
                PageScaling = PageScaling.FitToPrintableArea,
                OutputRange = new OutputRange("1")
            };
            //for testing with different page sizes
            printOptions.PageSettings.PaperSize = printOptions.PrinterSettings.PaperSizes.Cast<PaperSize>().FirstOrDefault(q => q.Kind == PaperKind.A5);
            report.Print(printOptions);
        }
    }
}
