﻿using C1.Web.Wijmo.Controls.C1GridView;
using System;
using System.Data;
using System.Web.UI.WebControls;

namespace WebApplication1
{
    public partial class Default : System.Web.UI.Page
    {
        public string CurrencySymbolHtml { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
            // Get the culture-specific symbol and wrap it in HTML
            // Using System.Globalization.CultureInfo.CurrentCulture or your Util.GetCulture()
            var culture = System.Globalization.CultureInfo.CurrentCulture;
            string symbol = culture.NumberFormat.CurrencySymbol;

            // your <span> formatting
            CurrencySymbolHtml = $"<span style=\"max-width:85px;display:inline-block;overflow:hidden\">{symbol}</span>&nbsp;";

            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        private void BindGrid()
        {
            DataTable dt = GetSampleData();
            C1GridView1.DataSource = dt;
            C1GridView1.DataBind();

            SetPercentageFooter(dt);

            // Configure Grouping for the first column (Department)
            if (C1GridView1.Columns.Count > 0)
            {
                // Let's assume Column[0] is our new 'Department' column
                var col = (C1BoundField)C1GridView1.Columns[0];

                // 2025v2 Grouping Logic
                col.GroupInfo.GroupSingleRow = false;
                col.GroupInfo.Position = GroupPosition.Header;
                col.GroupInfo.OutlineMode = OutlineMode.StartExpanded;

                col.RowMerge = RowMerge.Free;
            }
        }

        private DataTable GetSampleData()
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("Department", typeof(string));
            dt.Columns.Add("Number of requests", typeof(int));
            dt.Columns.Add("Counted to the end", typeof(int));
            dt.Columns.Add("Completion rate", typeof(double));

            // Data for "Sales" Group
            dt.Rows.Add("Sales", 100, 90, 90.00);
            dt.Rows.Add("Sales", 50, 45, 90.00);

            // Data for "Support" Group
            dt.Rows.Add("Support", 200, 180, 90.00);
            dt.Rows.Add("Support", 10, 2, 20.00);

            // Data for "IT" Group
            dt.Rows.Add("IT", 80, 80, 100.00);

            return dt;
        }

        private void SetPercentageFooter(DataTable dt)
        {
            if (dt != null && dt.Rows.Count > 0 && C1GridView1.FooterRow != null)
            {
                double totalRequests = Convert.ToDouble(dt.Compute("Sum([Number of requests])", ""));
                double totalCompletions = Convert.ToDouble(dt.Compute("Sum([Counted to the end])", ""));

                double overallPercentage = (totalRequests > 0) ? (totalCompletions / totalRequests * 100) : 0;

                Label lblFooter = C1GridView1.FooterRow.FindControl("lblPercentageFooter") as Label;
                if (lblFooter != null)
                {
                    lblFooter.Text = "Total Avg: " + overallPercentage.ToString("F2") + "%";
                }
            }
        }

        protected void C1GridView1_ColumnGrouped(object sender, C1GridViewColumnGroupedEventArgs e)
        {

        }

        protected void C1GridView1_ColumnGrouping(object sender, C1GridViewColumnGroupEventArgs e)
        {

        }
    }
}